<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage controllers
* @filesource
*/

/** */
// This can be removed if you use Modular Extensions
require_once APPPATH.'/libraries/REST_Controller.php';
require_once APPPATH.'/third_party/Paginator.php';
require_once 'admin_controller.php';

/**
* @package direct-as-a-service
* @subpackage controllers
*/
class Facilities extends Admin_controller
{
	public function __construct(){
		parent::__construct();
		$this->load->library(array('session','encrypt','eventlog','permissions','auth'));
		$this->load->model('facilitymodel');
		$this->load->model('usersmodel');
		$this->load->helper('url'); 
		
		//check if the user is authorized
		$login_status = $this->session->userdata('is_loggedin');
		if(!isset($login_status) || $login_status !== 'true') {
			//if the user has authenticated via CAC, the controller will load 
			//if not then a 401 Unauthorized error will be shown
			if(!$this->auth->perform_auth()) { show_error('Unauthorized',401); }
		}
		
		//check if user has agreed to dod banner
		$banner = $this->session->userdata('banner_agree');
		if (!isset($banner) || $banner !== 'true') {
			$this->session->set_flashdata('redirect_uri',uri_string());
			redirect('onboarding/banner');
		}
	}
	
	public function index() {
		//get user id from session to get permissions
		$permissions = $this->account_permissions;
		$show = $this->show;
		
		if(isset($show['facilities']) && $show['facilities']) { $this->facility_list(); }
		else { redirect('onboarding'); }
	}
	
		/* -----------------------------*
	 *  APPLICATIONS TAB FUNCTIONS  *
	 * -----------------------------*/
	
	/*
	 * Facility List loads the facility list view for the facility administrator. 
	 */
	public function facility_list()
	{		
		$data['title'] = 'Direct API: Facility List';
		$data['active_tab'] = array('facilities'=>true);
		
		//grab flash data to display to the user
		if(!empty($this->session->flashdata('message'))) { $data['message'] = $this->session->flashdata('message'); }
		if(!empty($this->session->flashdata('error_message'))) { $data['error_message'] = $this->session->flashdata('error_message'); }
		if(!empty($this->session->flashdata('success_message'))) { $data['success_message'] = $this->session->flashdata('success_message'); }
	
		
		//get user id from session to get permissions
		
		$user_id = $this->user->id();
		$permissions = $this->account_permissions;
		$data['show'] = $this->show;
		$prefix = 'active_';
		//push back the page number and items per page on the active tab from the attempt to edit and save an facility
		$active_page_select_from_facility_save = $this->session->flashdata('active_page_select_from_facility_save');
		$active_items_per_page_from_facility_save = $this->session->flashdata('active_items_per_page_from_facility_save');
		if($active_page_select_from_facility_save) {
			$active_destination_page = $active_page_select_from_facility_save;
		}
		if($active_items_per_page_from_facility_save) {
			$active_items_per_page = $active_items_per_page_from_facility_save;
		}
		
		$active_pages = new Paginator($prefix);
		$active_pages->page_setup($active_bar_page, $active_jump_page, $active_items_per_page, $active_destination_page);
		
		if($permissions['API']['admins']) {
			
			$facility_list = $this->facilitymodel->get_facilities_by_page_number(($active_destination_page - 1) * $active_items_per_page + 1, $active_items_per_page);
			$facility_list_size = $this->facilitymodel->get_facility_list_size()->result();
		}
		
		//the active facilities list
		if ($facility_list) {
			
			$data['facility_list'] = $facility_list->result();
			//pagination setup
			$data['active_items_per_page'] = $active_items_per_page;
			$facility_list_size = $facility_list_size[0]->count;
			$data['active_num_pages'] = ceil($facility_list_size / $active_items_per_page);
			$data['active_cur_page'] = $active_destination_page;
			$active_pages->items_total = $facility_list_size;
			$active_pages->current_page = $active_destination_page;
			$active_pages->paginate();
			$data['active_pagination_bar'] = $active_pages->display_pages();
			$data['active_items_per_page_dropdown'] = $active_pages->display_items_per_page();
			$data['active_size'] = $facility_list_size;
		}
		else {
			$data['active_list'] = array();
		}
		
		if(isset($_POST['prefix'])) {
			$data['anchor'] = $_POST['prefix'] . 'link';
		}
		//assign form values
		$form_values = array();
		$form_values['active_page_select'] = $active_destination_page;
		$form_values['active_items_per_page'] = $active_items_per_page;
		$data['form_values'] = $form_values;
		
		if($data['show']['facilities']) { $this->load->view('api/facilities/facility_list', $data); }
		else { show_error('Forbidden',403); }
	}
	
	/* 
	 * Facility edit is the edit page for changing meta-data about the facility. 
	 */
	public function facility_edit($id = null, $active_cur_page = null, $active_items_per_page = null)
	{
		//set current page and items per page on the sub-tabs
		$data['active_cur_page'] = $active_cur_page;
		$data['active_items_per_page'] = $active_items_per_page;
		
		//if(is_null($id)) { return $this->facility_list(); } //if no id is set, go back to facility list
		$data['title'] = 'Direct API: Facility Edit';
		$data['active_tab'] = array('facilities'=>true);
		//get user id from session to get permissions
		$user_id = $this->user->id();
		$permissions = $this->account_permissions;
		$data['show'] = $this->show;
		$data['api_admins'] = $permissions['API']['admins'];
		if($permissions['API']['admins']) {
			//add the validation errors
			if(!empty($this->session->flashdata('error_message'))) { 
				$data['error_message'] = $this->session->flashdata('error_message'); 
				//add post data to from flashdata
				$data['fac_name'] = $this->session->flashdata('fac_name');
				$data['active'] = $this->session->flashdata('active');
			}
			
			if($data['show']['facilities']) {
				if (isset($id) && is_numeric($id)){ //make sure its a valid id
					$fac = $this->facilitymodel->get_facility($id)->result();
					if($fac) { //if there is a result, load the view
						$data['fac'] = $fac[0];
						$this->load->view('api/facilities/facility_edit', $data);
					}
					else { show_404(); } //if not valid id or no result, show 404
				}
				else { 
					//show_404(); 
					$this->load->view('api/facilities/facility_edit', $data);
				}
			}
			else { show_error('Forbidden',403); }
		}else { show_error('Forbidden',403); }
	}	
	
	/* 
	 * Facility save handles the storing of values into the database. 
	 */
	public function facility_save(){
		$this->load->library('form_validation');
		
		//push back the page number and items per page from the attempt to edit an facility
		$this->session->set_flashdata('active_page_select_from_facility_save',$this->input->post('active_page_select_from_facility_save',TRUE));
		$this->session->set_flashdata('active_items_per_page_from_facility_save',$this->input->post('active_items_per_page_from_facility_save',TRUE));
		
		//retrieve the facility id
		$id = $this->input->post('fac_id',TRUE);
		//use permissions to determine whether to allow function call at all
		
		$cur_id=$this->user->id();
		$permissions = $this->account_permissions;
		$message = '';
		if($permissions['API']['admins']) {
			//test if the id has been passed and if it is a valid number
			if(empty($id) || !$this->is->nonzero_unsigned_integer($id)){
				$this->session->set_flashdata('error_message', 'No facility id specified. To create a new facility, please click on the Create New Facility button.'); 
				redirect('facilities/list');
			}
			else {
				//retrieve the facility from the database from its id
				$fac_arr = $this->facilitymodel->get_facility($id)->result();
				//if the facility exists
				if($fac_arr) {
					$fac = $fac_arr[0];
					$existing_name = $fac->name;
					//grab the other form values that have been passed
					$name = $this->input->post('fac_name',TRUE);
					$active = $this->input->post('active',TRUE);
					
					//set required fields for validation
					if ($existing_name === $name)
						$this->form_validation->set_rules('fac_name','Facility Name','required|max_length[400]');
					else
						$this->form_validation->set_rules('fac_name','Facility Name','required|is_unique[facility.name]|max_length[400]');
					
					if($this->form_validation->run() === TRUE) {
						if($this->facilitymodel->save_facility($id, $name, $active)) {
							$message = 'Facility "'.$name.'" has been saved successfully.';
							$this->eventlog->create_event(7, $id ,3 ,$cur_id, "Edit facility", time(), 1);
						}
						else { 
							$error_message = 'Facility "'.$name.'" failed to save.'; 
							$this->eventlog->create_event(7, $id, 3 ,$cur_id, "Edit facility", time(), 0);
						}
					}
					else {
						$this->session->set_flashdata('error_message',validation_errors());
						$form_data = $this->input->post(NULL,TRUE);
						foreach($form_data as $key => $value) {
							$this->session->set_flashdata($key, $value);
						}
						if(!empty(trim($id))) { redirect('facilities/edit/'.$id); }
						else{
							$this->session->set_flashdata('message', 'No facility id specified. To request a new facility please follow the link on the onboarding tab.'); 
							redirect('facilities/list'); 
						}
					}
				}
				//if no facility exists in the database return to the edit screen
				else {
					$this->session->set_flashdata('error_message', 'No facility exists for id '.$id.'. Please select another facility to edit.'); 
					redirect('facilities/list');
				}
			}
			$this->session->set_flashdata('success_message',$message);
			if(isset($error_message)) { $this->session->set_flashdata('error_message',$error_message); }
			redirect('facilities/list');
			
		}
		else { show_error('Forbidden', 403); }
	}
	
	public function facility_create() {
		$this->load->library('form_validation');
		//get user id from session to get permissions
		$permissions = $this->account_permissions;
		$user_id=$this->user->id();
			
		//get field values from the form
		$fac_name = $this->input->post('fac_name', TRUE);
		$active = $this->input->post('is_active', TRUE);
	
		//use permissions to determine whether to allow function call at all
		if(isset($permissions['API']['admins']) && $permissions['API']['admins']) {
			//set validation for the fields
			$this->form_validation->set_rules('fac_name','Facility Name','required|is_unique[facility.name]|max_length[400]');
				
			if($this->form_validation->run() === TRUE) {
				
				if($this->facilitymodel->save_facility(null, $fac_name, $active)) {
					$this->eventlog->create_event(7, 0, 3,$user_id, "Create Facility: ".$fac_name, time(), 1);
					$message = 'Facility, ' . $fac_name . ', has been created successfully.';
					$this->session->set_flashdata('success_message', $message);
				}
				else {
					$this->eventlog->create_event(7, 0, 3,$user_id, "Create Facility: ".$fac_name, time(), 0);
					$this->session->set_flashdata('error_message', 'Failed to create Facility, ' . $fac_name . '.');
				}
	
			}
			else {
				$this->session->set_flashdata('error_message',validation_errors());
				$this->session->set_flashdata('fac_name', $fac_name);
				$this->session->set_flashdata('is_active', $active);
			}
		}
		else {
			$this->eventlog->create_event(7, 0, 3 ,$user_id, "Create Facility: ".$fac_name, time(), 2);
			show_error(403,'Unauthorized');
		}
		redirect('facilities/list/#create');
	}
}